#
# spec file for package gnome-valgrind-session (version 1.0)
#
# Copyright (c) 2006 SUSE LINUX Products GmbH, Nuernberg, Germany.
# This file and all modifications and additions to the pristine
# package are under the same license as the package itself.
#
# Please submit bugfixes or comments via http://bugs.opensuse.org/
#

# norootforbuild

Name:           gnome-valgrind-session
PreReq:         /usr/bin/gnome
License:        GNU General Public License (GPL) - all versions
Group:          System/GUI/GNOME
Autoreqprov:    on
Version:        1.0
Release:        1
Summary:        GNOME Valgrind instrumented sessions
Source:         %{name}-%{version}.tar.bz2
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
Provides:       gnome-valgrind-session
Obsoletes:      gnome-valgrind-session
Requires:       valgrind gnome-session
BuildArchitectures: noarch

%description
Adds new types of GNOME session to the login manager's session menu. These let
you instrument your entire session with Valgrind for debugging purposes. The
generated logs are collected and subjected to simple postprocessing when you
log out. The result is saved to a file in your home directory.

%prep

%setup

%build

%install

install -D -m 0755 gnome-valgrind-errors $RPM_BUILD_ROOT/usr/bin/gnome-valgrind-errors
install -D -m 0755 gnome-valgrind-errors-postprocess $RPM_BUILD_ROOT/usr/bin/gnome-valgrind-errors-postprocess
install -D -m 0755 gnome-valgrind-leaks $RPM_BUILD_ROOT/usr/bin/gnome-valgrind-leaks
install -D -m 0755 gnome-valgrind-leaks-postprocess $RPM_BUILD_ROOT/usr/bin/gnome-valgrind-leaks-postprocess
install -D -m 0644 gnome-valgrind-errors.desktop $RPM_BUILD_ROOT/usr/share/xsessions/gnome-valgrind-errors.desktop
install -D -m 0644 gnome-valgrind-leaks.desktop $RPM_BUILD_ROOT/usr/share/xsessions/gnome-valgrind-leaks.desktop

%clean
rm -rf $RPM_BUILD_ROOT

%pre

%post

%postun

%files

/usr/bin/gnome-valgrind-errors
/usr/bin/gnome-valgrind-errors-postprocess
/usr/bin/gnome-valgrind-leaks
/usr/bin/gnome-valgrind-leaks-postprocess
/usr/share/xsessions/gnome-valgrind-errors.desktop
/usr/share/xsessions/gnome-valgrind-leaks.desktop

%changelog -n gnome-valgrind-session
* Fri Nov 10 2006 - hpj@novell.com
- Initial version.
